#!/bin/bash
#
# Install system dependencies required to run Cloud Scanner of Death
# Run this on the target machine before running the scanner
#
echo "Installing Qt and graphics dependencies..."
# Detect package manager
if command -v apt-get &> /dev/null; then
    # Debian/Ubuntu/Kali
    sudo apt-get update
    sudo apt-get install -y \
        libxcb-xinerama0 \
        libxcb-cursor0 \
        libxcb-icccm4 \
        libxcb-image0 \
        libxcb-keysyms1 \
        libxcb-randr0 \
        libxcb-render-util0 \
        libxcb-shape0 \
        libxcb-xfixes0 \
        libxcb-xkb1 \
        libxkbcommon-x11-0 \
        libgl1-mesa-glx \
        libegl1 \
        libfontconfig1 \
        libdbus-1-3 \
        libxcb1
    
    echo "Dependencies installed successfully!"
    
elif command -v dnf &> /dev/null; then
    # Fedora/RHEL
    sudo dnf install -y \
        xcb-util-wm \
        xcb-util-image \
        xcb-util-keysyms \
        xcb-util-renderutil \
        libxkbcommon-x11 \
        mesa-libGL \
        mesa-libEGL \
        fontconfig \
        dbus-libs
    
    echo "Dependencies installed successfully!"
    
elif command -v pacman &> /dev/null; then
    # Arch Linux
    sudo pacman -S --noconfirm \
        xcb-util-wm \
        xcb-util-image \
        xcb-util-keysyms \
        xcb-util-renderutil \
        libxkbcommon-x11 \
        mesa \
        fontconfig \
        dbus
    
    echo "Dependencies installed successfully!"
    
else
    echo "Unknown package manager. Please install Qt dependencies manually."
    exit 1
fi
echo ""
echo "All dependencies installed. 
