# Finding IP Addresses for Transfer of Death
## Complete Guide for Windows, Linux, and Mac

---

## Quick Answer: The App Shows Your IPs!

**Transfer of Death automatically detects and displays all your IP addresses** at the top of the window when you start it.

Look for: `Your IP Address(es): 192.168.86.116 | 192.168.56.1`

**This is usually all you need!** But if you want to verify or find IPs manually...

---

## WINDOWS

### Method 1: Command Prompt (Easiest)

1. Press `Windows + R`
2. Type `cmd` and press Enter
3. Type: `ipconfig`
4. Press Enter

**What to look for:**
```
Ethernet adapter Ethernet:
   IPv4 Address. . . . . . . . . . . : 192.168.86.116

Wireless LAN adapter Wi-Fi:
   IPv4 Address. . . . . . . . . . . : 192.168.1.100

Ethernet adapter Ethernet 2 (ProtonVPN):
   IPv4 Address. . . . . . . . . . . : 10.2.0.45
```

### Method 2: PowerShell (Cleaner Output)

1. Press `Windows + X`
2. Select "PowerShell" or "Terminal"
3. Type: `Get-NetIPAddress -AddressFamily IPv4 | Select-Object IPAddress, InterfaceAlias`

### Method 3: GUI (Settings)

1. Press `Windows + I` (Settings)
2. Click "Network & Internet"
3. Click your connection (Wi-Fi or Ethernet)
4. Look for "IPv4 address"

### Method 4: Task Manager

1. Press `Ctrl + Shift + Esc`
2. Click "Performance" tab
3. Click your network adapter (Wi-Fi or Ethernet)
4. IP shown at bottom

---

## LINUX

### Method 1: ip command (Modern Linux)

Open terminal and type:
```bash
ip addr show
```

Or for cleaner output:
```bash
ip -4 addr show | grep inet
```

**What to look for:**
```
inet 192.168.86.116/24 brd 192.168.86.255 scope global eth0
inet 10.8.0.5/24 brd 10.8.0.255 scope global tun0  # VPN
```

### Method 2: ifconfig (Older Linux)

```bash
ifconfig
```

Or:
```bash
ifconfig | grep "inet " | grep -v 127.0.0.1
```

### Method 3: hostname command

```bash
hostname -I
```

This shows all IPv4 addresses in one line.

### Method 4: nmcli (NetworkManager)

```bash
nmcli device show | grep IP4.ADDRESS
```

### Common Linux Interface Names:

- `eth0` / `enp0s3` = Wired Ethernet
- `wlan0` / `wlp2s0` = Wireless
- `tun0` / `tun1` = VPN tunnel
- `lo` = Loopback (127.0.0.1) - **ignore this one**

---

## MAC (macOS)

### Method 1: System Preferences (GUI)

1. Click Apple menu → System Preferences
2. Click "Network"
3. Select your connection (Wi-Fi or Ethernet)
4. IP address shown on the right

**OR in newer macOS:**

1. Click Apple menu → System Settings
2. Click "Network"
3. Select your connection
4. Click "Details" or expand to see IP

### Method 2: Terminal (Command Line)

Open Terminal (Cmd + Space, type "Terminal") and use:

```bash
ifconfig | grep "inet " | grep -v 127.0.0.1
```

Or for cleaner output:
```bash
ipconfig getifaddr en0    # Wi-Fi
ipconfig getifaddr en1    # Ethernet (sometimes)
```

### Method 3: All Network IPs

```bash
ifconfig | grep "inet " | awk '{print $2}'
```

### Method 4: networksetup

```bash
networksetup -listallhardwareports
```

Then for each interface:
```bash
ipconfig getifaddr en0
```

### Common Mac Interface Names:

- `en0` = Usually Wi-Fi
- `en1` = Usually Ethernet (or Thunderbolt)
- `utun0` / `utun1` = VPN tunnel
- `lo0` = Loopback (127.0.0.1) - **ignore this one**

---

## WHICH IP ADDRESS SHOULD I USE?

You might see multiple IP addresses. Here's which one to use:

### Scenario 1: Same Local Network (LAN)
**Both computers connected to the same Wi-Fi/Router**

**Use:** `192.168.x.x` or `10.0.x.x` addresses

Examples:
- ✅ `192.168.1.100`
- ✅ `192.168.86.116`
- ✅ `10.0.0.45`
- ❌ NOT `127.0.0.1` (that's localhost)

### Scenario 2: VPN Connection
**Both computers on same VPN (ProtonVPN, Tailscale, etc.)**

**Use:** The VPN-assigned IP address

ProtonVPN:
- Usually `10.2.x.x` or `10.8.x.x`

Tailscale:
- Usually `100.x.x.x`

WireGuard/OpenVPN:
- Check your VPN config, usually `10.x.x.x`

**Important:** Use the VPN IP, NOT your local LAN IP!

### Scenario 3: Over the Internet
**Computers in different locations (not recommended without VPN)**

This is complicated and NOT recommended. Use a VPN instead (Tailscale is easiest).

If you must: You need port forwarding on your router and to use your **public IP**.

Find public IP: Visit https://whatismyipaddress.com

---

## TAILSCALE SPECIFIC (Recommended for VPN)

If using Tailscale (easiest VPN for P2P):

**Windows:**
```cmd
tailscale ip -4
```

**Linux/Mac:**
```bash
tailscale ip -4
```

This gives you your Tailscale IP (usually `100.x.x.x`)

---

## COMMON IP ADDRESS RANGES

| IP Range | Meaning |
|----------|---------|
| `192.168.x.x` | Local network (most common for home) |
| `10.x.x.x` | Local network OR VPN |
| `172.16.x.x` - `172.31.x.x` | Local network (corporate) |
| `100.x.x.x` | Tailscale VPN |
| `127.0.0.1` | Localhost (NEVER use for connecting between PCs) |
| Anything else | Usually public IP or special VPN |

---

## TESTING CONNECTIVITY

Before trying to connect in Transfer of Death, test if the PCs can reach each other:

### Windows:
```cmd
ping [IP_ADDRESS]
```

Example:
```cmd
ping 192.168.86.116
```

### Linux/Mac:
```bash
ping -c 4 [IP_ADDRESS]
```

Example:
```bash
ping -c 4 192.168.86.116
```

**Good result:**
```
Reply from 192.168.86.116: bytes=32 time=2ms TTL=64
```

**Bad result:**
```
Request timed out.
```

If ping fails, the PCs can't reach each other (firewall, wrong network, etc.)

---

## QUICK REFERENCE CARD

### Finding Your IP:

| OS | Quick Command |
|----|---------------|
| **Windows** | `ipconfig` |
| **Linux** | `ip addr show` or `hostname -I` |
| **Mac** | `ifconfig` or `ipconfig getifaddr en0` |

### Which IP to Use:

| Scenario | IP to Use | Example |
|----------|-----------|---------|
| **Same Wi-Fi/LAN** | 192.168.x.x | 192.168.1.100 |
| **VPN (ProtonVPN)** | 10.x.x.x | 10.2.0.45 |
| **VPN (Tailscale)** | 100.x.x.x | 100.64.0.5 |
| **VPN (WireGuard)** | Check VPN config | Usually 10.x.x.x |

---

## TROUBLESHOOTING

### "I see multiple IP addresses, which one?"

Run the app! It shows all your IPs. Try each one until it works.

**Priority order:**
1. If on VPN → Use VPN IP (10.x.x.x or 100.x.x.x)
2. If same network → Use 192.168.x.x
3. If you have multiple 192.168 IPs → Try the one from your active connection (Wi-Fi or Ethernet)

### "None of my IPs work!"

1. **Check if you can ping:** Try `ping [IP]` from the other PC
2. **Check firewall:** Make sure Transfer of Death is allowed
3. **Check port:** Make sure both PCs use the same port
4. **Check network:** Are you really on the same network/VPN?

### "I only see 127.0.0.1"

This means you're not connected to any network!

**Windows:** Check Wi-Fi/Ethernet connection
**Linux:** Check `ip link` to see if interfaces are up
**Mac:** Check System Preferences → Network

### "The app shows different IPs than my command"

The app is correct! It uses the same method as your OS to detect IPs. The difference might be:
- Timing (connected to different network)
- VPN started/stopped
- Multiple network adapters

Trust the app's display.

---

## PORTING THE APP TO LINUX/MAC

The app should work on Linux/Mac with minimal changes! PyQt6 and socket libraries are cross-platform.

**Changes needed:**

1. **Remove Windows-specific code:**
   - `socket.SIO_KEEPALIVE_VALS` (Windows-only)
   - Firewall check functions

2. **Test Python installation:**
   ```bash
   python3 --version
   pip3 install PyQt6
   python3 Transfer_of_Death_v3_7_VPN_PORT_FIX.py
   ```

3. **Platform-specific keepalive:**
   - Already handled! The code checks `if sys.platform == 'win32'`
   - Linux/Mac use `TCP_KEEPIDLE`, `TCP_KEEPINTVL`, `TCP_KEEPCNT`

**That's it!** The networking code is already cross-platform.

---

## EXAMPLE SCENARIOS

### Example 1: Same Home Network

**PC #1 (Laptop):**
- IP: 192.168.86.116
- Port: 8000

**PC #2 (Desktop):**
- Run Transfer of Death
- Enter IP: `192.168.86.116`
- Enter Port: `8000`
- Click Connect

### Example 2: Both on ProtonVPN

**PC #1:**
- ProtonVPN IP: 10.2.0.45
- Port: 12345 (changed from 8000 because ProtonVPN blocks 8000)

**PC #2:**
- Run Transfer of Death
- Change port to: `12345` (Settings → Change Port)
- Enter IP: `10.2.0.45`
- Enter Port: `12345`
- Click Connect

### Example 3: Both on Tailscale

**PC #1:**
- Tailscale IP: 100.64.0.10
- Port: 8000

**PC #2:**
- Enter IP: `100.64.0.10`
- Enter Port: `8000`
- Click Connect

Works instantly! Tailscale handles all NAT/firewall traversal.

---

## SUMMARY

1. **Let the app detect IPs** - It shows them automatically!
2. **Use the right IP for your scenario:**
   - Same network → 192.168.x.x
   - VPN → 10.x.x.x or 100.x.x.x
3. **Test with ping first** to verify connectivity
4. **Both PCs must use the same port**
5. **When in doubt, use Tailscale** - it's the easiest!

---

*Last updated: Transfer of Death v3.7*
